/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GTRANS_DB_EDITOR_H__
#define __GTRANS_DB_EDITOR_H__

#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>

  
#define GTRANS_DB_EDITOR(obj)            GTK_CHECK_CAST(obj,\
                                         gtrans_db_editor_get_type(),\
                                         GTransDbEditor)

#define GTRANS_DB_EDITOR_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass,\
                                         gtrans_db_editor_get_type(),\
                                         GTransDbEditorClass)

#define GTRANS_IS_DB_EDITOR(obj)         GTK_CHECK_TYPE(obj,\
                                         gtrans_db_editor_get_type())


typedef struct _GTransDbEditor        GTransDbEditor;
typedef struct _GTransDbEditorClass   GTransDbEditorClass;


struct _GTransDbEditor {
	
	/* The GtkWidow */
	GtkWindow         window;
	
	/* A glist for all the editors children, could
	 * be designer, opened tables ... */
	GList            *children;

	/* The notebook to display the various editable items,
	 * (tables, querys, forms) */
	GtkWidget        *notebook;
	

	/* Icon list for the tables */
	GtkWidget        *table_ilist;
	
	/* Data of the selected icon, NULL if not selected */
	gpointer          table_idata;
	
	/* The pos of the selected table icon, -1 if not selected */
	gint              table_ipos;
	
	/* The connection to the server */
	GTransIFaseConn  *conn;
};


struct _GTransDbEditorClass {
	
	GtkWindowClass parent_class;
	void (* new_table)       (GTransDbEditor *gtrans_db_ed);
	void (* open_table)      (GTransDbEditor *gtrans_db_ed);
	void (* del_table)       (GTransDbEditor *gtrans_db_ed);
	void (* refresh_tables)  (GTransDbEditor *gtrans_db_ed);
	void (* refresh)         (GTransDbEditor *gtrans_db_ed);
	void (* close)           (GTransDbEditor *gtrans_db_ed);
};


guint
gtrans_db_editor_get_type(void);



/**
 * gtrans_db_editor_new
 * @conn  : Connection to a database server
 *
 * Create a new database editor (GTransDbEditor), arrown
 * the specified connection.
 */
GtkWidget *
gtrans_db_editor_new(GTransIFaseConn *conn);



/**
 * gtrans_db_editor_remove_table
 * @gde  : The GTransDbEditor
 * @pos  : The position of the GnomeIconListItem
 *
 * Remove the GnomeIconListItem at @pos, in the table's page. 
 */
void
gtrans_db_editor_remove_table(GTransDbEditor *gde,
			      gint            pos);



/**
 * gtrans_db_editor_refresh_tables
 * @gde : The Database Editor
 * @res : A GTransIFaseResult retriving the tables in a db.
 *
 * Refresh the table icons. This is, clear them all
 * and read them from the database.
 */
void
gtrans_db_editor_refresh_tables(GTransDbEditor    *gde,
				GTransIFaseResult *res);



/**
 * gtrans_db_editor_refresh
 * @gde : The Database Editor
 * @res : A GTransIFaseResult retriving the tables in a db.
 *
 * Refresh all the icons. This is, clear them all
 * and read them from the database.
 */
void
gtrans_db_editor_refresh(GTransDbEditor    *gde,
			 GTransIFaseResult *res);



/*
 * gtrans_db_editor_fill_ilist_with_tables
 * @gde : The Database Editor
 * @res : A GTransIFaseResult retriving the tables in a db.
 *
 * Fill the tabpe's page of the Database Editor with the
 * table icons.
 */
void
gtrans_db_editor_fill_with_tables(GTransDbEditor    *gde,
				  GTransIFaseResult *res);




/**
 * gtrans_db_editor_add_child:
 * gde   : The GTransDbEditor
 * child : A widget (Table Designer, Table Editor, ...)
 *
 * Sets @gde to be the paren of @child, so when we destroy
 * the @gde @child will get destroyed.
 */
void
gtrans_db_editor_add_child(GTransDbEditor *gde,
			   GtkWidget      *child);



/**
 * gtrans_db_editor_remove_child:
 * gde   : The GTransDbEditor
 * child : A widget
 *
 * Removes @child from the @gde children list.
 */
void
gtrans_db_editor_remove_child(GTransDbEditor *gde,
			      GtkWidget      *child);



#endif /* __GTRANS_DB_EDITOR_H__ */






