// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2004 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

#include "CommPeerListener.h"

#include "CommPeer.h"
#include "CommServer.h"

#include "common/id.h"
#include "common/log.h"

static const bool debug_flag = false;

/// \brief Constructor for listener socket object.
///
/// @param svr Reference to the object that manages all socket communication.
CommPeerListener::CommPeerListener(CommServer & svr) : CommListener(svr)
{
}

CommPeerListener::~CommPeerListener()
{
}

int CommPeerListener::create(int asockfd, const char * address)
{
    std::string peer_id;
    if (newId(peer_id) < 0) {
        log(ERROR, "Unable to accept connection as no ID available");
        close(asockfd);
        return -1;
    }

    CommPeer * newpeer = new CommPeer(m_commServer, asockfd, address, peer_id);

    newpeer->setup();

    // Add this new peer to the list.
    m_commServer.addSocket(newpeer);

    return 0;
}
