#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h> 
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <forms.h>
#include "rtty_f.h"
#include "common.h"
#include "fft.h"

extern FD_rtty_form *fd_rtty_form;

Display *mydisplay;
Window root,mywindow;
GC mygc;
XEvent myevent;
KeySym mykey;
XSizeHints myhint;
Colormap cmap;
XColor color;
int myscreen;
int mypal[7],X,Y,redisp=1;

/*-----------------------------------------------------*/

void draw_osc()
{
	unsigned int i,ix,si;
	float *pf,m;
	static XPoint dat[1024],odat[1024];
	
	/* Erasing window & drawing zero line*/
	if (redisp) {
		XClearWindow(mydisplay,mywindow);
		XSetForeground(mydisplay,mygc,mypal[1]);
		XDrawLine(mydisplay,mywindow,mygc,0,Y/2,X,Y/2);
	}
	/* Waiting for a positive-slope zero-cossing */
	if (disdp->mode==2) {
		ix=disdp->inp+1;
		pf=disdp->in;
		m=1.0/128.;
		si=1;
		XSetForeground(mydisplay,mygc,mypal[2]);
	} else if (disdp->mode==3) {
		ix=disdp->outp+1;
		pf=disdp->out;
		m=1.0/128./64.;
		si=FS/fskdp->dr/20;
		XSetForeground(mydisplay,mygc,mypal[3]);
	} else return;
	ix&=NDBUF-1;
	
	/* Waiting for a positive-slope zero-cossing */
	for(i=0;i<NDBUF/2;i++) {
		if(pf[ix]<0 && pf[(ix+1)&NDBUF-1]>0) break;
		ix++; ix&=NDBUF-1;
	}
	
	/* Computing the new trace */
	for (i=0;i<X;i++) {
		dat[i].x=i;
		dat[i].y=Y/2-Y/2*(pf[ix])*m;
		ix+=si; ix&=NDBUF-1;
	}
	
	/* Erasing old trace*/
	if(!redisp) XDrawLines(mydisplay,mywindow,mygc,odat,X,CoordModeOrigin);
	
	/* Drawing the new trace */
	XDrawLines(mydisplay,mywindow,mygc,dat,X,CoordModeOrigin);
	
	for (i=0;i<X;i++) odat[i]=dat[i];
	redisp=0;
}

/**********************************************************************/

void draw_spectrum()
{
	unsigned int i,ix,np,x,x1;
	float fmax;
	static XPoint dat[1024],odat[1024];
	complex a[NSAMPLES];

	fmax=fskdp->spacef+fskdp->markf;
		
	/* Erasing window & drawing background */
	if (redisp) {
		XClearWindow(mydisplay,mywindow);
		
		XSetForeground(mydisplay,mygc,mypal[5]);
		x =(fskdp->spacef - fskdp->dr)*X/fmax;
		x1=(2*fskdp->dr)*X/fmax;
		XFillRectangle(mydisplay,mywindow,mygc, x, 0, x1, Y);
		
		XSetForeground(mydisplay,mygc,mypal[4]);
		x =(fskdp->markf - fskdp->dr)*X/fmax;
		XFillRectangle(mydisplay,mywindow,mygc, x, 0, x1, Y);
		
		XSetForeground(mydisplay,mygc,mypal[6]);
	}
	
	/* Computing the new trace */
	ix=disdp->inp+1;
	for (i=0;i<NSAMPLES;i++) {
		ix&=NDBUF-1;
		a[i].im=0.0;
		a[i].re=disdp->in[ix++]/128.0;
	}
	r_cosine(a);	/* Raised Cosine (Hanning) window */
	fft(a);		/* FFT transform */
	db(a);		/* Power spectrum (decibels) */
	np=NSAMPLES*fmax/FS;
	for (i=0;i<np;i++) {
		dat[i].x=i*X*FS/NSAMPLES/fmax;
		dat[i].y=(dat[i].y*7-a[i].re*Y/MINDB)/8;
	}
	
	/* Erasing old trace*/
	if(!redisp) XDrawLines(mydisplay,mywindow,mygc,odat,np,CoordModeOrigin);
	
	/* Drawing the new trace */
	XDrawLines(mydisplay,mywindow,mygc,dat,np,CoordModeOrigin);
	
	for (i=0;i<np;i++) odat[i]=dat[i];
	redisp=0;
}

/******************************************************************/

void graph_main()
{

	int i;
	unsigned short col[256];
	char text[10];
        XGCValues xgc;
	
	mywindow = fl_get_canvas_id(fd_rtty_form->canvasw);
	mydisplay=FL_FormDisplay(fd_rtty_form);
        myscreen=DefaultScreen(mydisplay);
	
        /* Allocating a private GC to avoid Forms damage ;) */
        /* We select a XOR drawing funtion in order to speed trace erase */
        xgc.function=GXxor;
        mygc=XCreateGC(mydisplay,mywindow,GCFunction,&xgc);
	
	/* Allocating colors for our palette */
	cmap=DefaultColormap(mydisplay,myscreen);
	color.red=0;
	color.green=0;
	color.blue=0;
	XAllocColor(mydisplay,cmap,&color);
	mypal[0]=color.pixel;
	color.blue=65535;
	XAllocColor(mydisplay,cmap,&color);
	mypal[1]=color.pixel;
	color.blue=0;
	color.green=65535;
	XAllocColor(mydisplay,cmap,&color);
	mypal[2]=color.pixel;
	color.red=65535;
	XAllocColor(mydisplay,cmap,&color);
	mypal[3]=color.pixel;
	color.red=0;
	color.green=32767;
	XAllocColor(mydisplay,cmap,&color);
	mypal[4]=color.pixel;
	color.red=49151;
	color.green=0;
	XAllocColor(mydisplay,cmap,&color);
	mypal[5]=color.pixel;
	color.red=65535;
	color.green=65535;
	color.blue=65535;
	XAllocColor(mydisplay,cmap,&color);
	mypal[6]=color.pixel;		
	
	
	XGetGeometry(mydisplay,mywindow,&root,&i,&i,&X,&Y,&i,&i);
	
	for(;;){
		if (disdp->mode==1) draw_spectrum();
		else if (disdp->mode>1) draw_osc();
		/* Events seems to be handled by the XForms thread, */
		/* so, we just ignode them */
		usleep(100000);	/* Up to 10 frames/sec */
	}
}
 
