/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FilterManager;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.io.RandomAccessFileInputStream;
import org.pdfbox.io.RandomAccessFileOutputStream;
import org.pdfbox.pdfparser.PDFStreamParser;

public class COSStream
extends COSDictionary {
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess file;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;

    public COSStream(RandomAccess storage) {
        this.file = storage;
    }

    public COSStream(COSDictionary dictionary, RandomAccess storage) {
        super(dictionary);
        this.file = storage;
    }

    public void replaceWithStream(COSStream stream) {
        this.clear();
        this.addAll(stream);
        this.file = stream.file;
        this.filteredStream = stream.filteredStream;
        this.unFilteredStream = stream.unFilteredStream;
    }

    public RandomAccess getScratchFile() {
        return this.file;
    }

    public List getStreamTokens() throws IOException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLength();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval = null;
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLength();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doDecode((COSName)filters);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = 0; i < filterArray.size(); ++i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doDecode(filterName);
                }
            } else {
                throw new IOException("Error: Unknown filter type:" + filters);
            }
        }
    }

    private void doDecode(COSName filterName) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        if (length == 0L) {
            this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
            done = true;
        } else {
            for (int tryCount = 0; !done && tryCount < 5; ++tryCount) {
                try {
                    BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                    this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                    filter.decode(input, this.unFilteredStream, this);
                    done = true;
                    continue;
                }
                catch (IOException io) {
                    --length;
                    exception = io;
                }
            }
        }
        if (!done) {
            throw exception;
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doEncode((COSName)filters);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = filterArray.size() - 1; i >= 0; --i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doEncode(filterName);
                }
            }
        }
    }

    private void doEncode(COSName filterName) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        filter.encode(input, this.filteredStream, this);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream.setExpectedLength(expectedLength);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public void setFilters(COSBase filters) throws IOException {
        this.setItem(COSName.FILTER, filters);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream = null;
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }
}

