/* *****************************************************************
IBM LICENSES THE SOFTWARE TO YOU ON AN "AS IS" BASIS, WITHOUT WARRANTY OF ANY
KIND. IBM HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES OR CONDITIONS, EITHER
EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR
CONDITIONS OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. You are
solely responsible for determining the appropriateness of using this Software
and assume all risks associated with the use of this Software, including but
not limited to the risks of program errors, damage to or loss of data, programs
or equipment, and unavailability or interruption of operations. Some
jurisdictions do not allow for the exclusion or limitation of implied
warranties, so the above limitations or exclusions may not apply to you.

IBM will not be liable for any direct damages or for any special, incidental,
or indirect damages or for any economic consequential damages (including lost
profits or savings), even if IBM has been advised of the possibility of such
damages. IBM will not be liable for the loss of, or damage to, your records or
data, or any damages claimed by you based on a third party claim. Some
jurisdictions do not allow for the exclusion or limitation of incidental or
consequential damages, so the above limitations or exclusions may not apply to
you.
*******************************************************************/

package com.ibm.bsf.engines.activescript;

import java.util.Vector;
import com.ibm.bsf.*;

public final class COMIDispatchBean implements Cloneable
{

   
 private byte[] IDispatchInterface; //Byte array containing point to a COM IDispatch Interface.

 private COMIDispatchBean(){return;} //Should not be called.

 public  COMIDispatchBean( byte[] pInterface)
 {
   IDispatchInterface= new byte[pInterface.length]; 
   System.arraycopy(pInterface,0,IDispatchInterface,0, pInterface.length);
// System.err.println( "created: " + this );
 }

 public byte[] getIDispatchInterface() throws BSFException
 {
  ActiveScriptEngine.nativeIdispatchAddRef(IDispatchInterface); 
  return IDispatchInterface;
 }
  
 public static COMIDispatchBean COMIDispatchBeanFactory( byte[] s) //Convient for c side to construct.
 {
   return new COMIDispatchBean(s);

 }

 public Object clone() throws CloneNotSupportedException
 {
   COMIDispatchBean d= null;
   System.err.println( "cloning: "  + this );
   try
   {

     d= (COMIDispatchBean) this.getClass().newInstance();
     d.IDispatchInterface= new byte[this.IDispatchInterface.length];
     System.arraycopy(this.IDispatchInterface,0,d.IDispatchInterface,0, this.IDispatchInterface.length);
     ActiveScriptEngine.nativeIdispatchAddRef(d.IDispatchInterface); 
   } catch( Exception e)
   {
     throw new CloneNotSupportedException();
   }
   System.err.println( "cloning: returned : " + d );
   return d;
 }

 public String toString()
 {
   return this.getClass().toString() + ":" + this.hashCode() + IDispatchInterface[3] + IDispatchInterface[2] + IDispatchInterface[1] + IDispatchInterface[0];
 }

 protected void finalize() throws Throwable
 {
   
  if(null != IDispatchInterface)
  {
 // System.err.println( "finalized: " + this );
    byte[]  x= IDispatchInterface ;
    IDispatchInterface = null;
    ActiveScriptEngine.nativeIdispatchDeleteRef(x); 
  }  
 }

}
