#ifndef MXH_H
#define MXH_H

/* 
  mxh.h -- Generic header file for mx extenstions

  This file should be included by every mx extension header file
  and the C file.

  (c) Marc-Andre Lemburg; all rights reserved
*/

/* We use our own definitions since Python's don't allow specifying
   both imported and exported symbols at the same time; these
   defines haven't been thoroughly tested yet, patches are most
   welcome :-)
*/

#if defined(__BORLANDC__)
#   define MX_EXPORT(type) type _export
#elif defined(_MSC_VER)
#   define MX_EXPORT(type) __declspec(dllexport) type
#elif defined(__WATCOMC__)
#   define MX_EXPORT(type) type __export 
#else
#   define MX_EXPORT(type) DL_IMPORT(type) 
#endif

#if defined(__BORLANDC__)
#   define MX_IMPORT(type) extern type __import
#elif defined(_MSC_VER)
#   define MX_IMPORT(type) extern __declspec(dllimport) type
#else
#   define MX_IMPORT(type) extern type
#endif

/* EOF */
#endif
