""" DateTime - Date and time handling routines and types

    (c) 1998, Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).
"""
__package_info__ = """
BEGIN PYTHON-PACKAGE-INFO 1.0
Title:			mxDateTime - Date and time handling routines and types
Current-Version:	1.3.0
Home-Page:		http://starship.skyport.net/~lemburg/mxDateTime.html
Primary-Site:		http://starship.skyport.net/~lemburg/mxDateTime-1.3.0.zip

This package contains two new types for Python, DateTime and
DateTimeDelta. These can be used to handle and store date/time
values and provide some basic arithmetic. For full documentation
see the home page.
END PYTHON-PACKAGE-INFO
"""
from DateTime import *
from DateTime import __version__

### Lazy import submodules
import LazyModule

ISO = LazyModule.LazyModule('ISO',locals(),globals())
ARPA = LazyModule.LazyModule('ARPA',locals(),globals())
ODMG = LazyModule.LazyModule('ODMG',locals(),globals())
Locale = LazyModule.LazyModule('Locale',locals(),globals())
Feasts = LazyModule.LazyModule('Feasts',locals(),globals())
Parser = LazyModule.LazyModule('Parser',locals(),globals())
NIST = LazyModule.LazyModule('NIST',locals(),globals())

del LazyModule

### Make the types pickleable:

# Shortcuts for pickle (reduces the pickle's length)
def _DT(absdate,abstime):
    return DateTimeFromAbsDateTime(absdate,abstime)
def _DTD(seconds):
    return DateTimeDeltaFromSeconds(seconds)

# Module init
class modinit:

    ### Register the two types
    import copy_reg
    def pickle_DateTime(d):
	return _DT,(d.absdate,d.abstime)
    def pickle_DateTimeDelta(d):
	return _DTD,(d.seconds,)
    copy_reg.pickle(DateTimeType,
		    pickle_DateTime,
		    _DT)
    copy_reg.pickle(DateTimeDeltaType,
		    pickle_DateTimeDelta,
		    _DTD)

del modinit
