---
title: PostgreSQL JDBC Driver 42.2.3 Released
date: 2018-07-12 12:02:03 +0300
categories:
  - new_release
version: 42.2.3
---
**Notable changes**
### Known issues
- SQL\_TSI\_YEAR is treated as hour, SQL\_TSI\_WEEK is treated as hour, SQL\_TSI\_MINUTE is treated as second (fixed in 42.2.4)

### Changed
- Reduce the severity of the error log messages when an exception is re-thrown. The error will be thrown to caller to be dealt with so no need to log at this verbosity by pgjdbc  [PR 1187](https://github.com/pgjdbc/pgjdbc/pull/1187)
- Deprecate Fastpath API [PR 903](https://github.com/pgjdbc/pgjdbc/pull/903)
- Support parenthesis in {oj ...} JDBC escape syntax [PR 1204](https://github.com/pgjdbc/pgjdbc/pull/1204)
- ubenchmark module moved pgjdbc/benchmarks repository due to licensing issues [PR 1215](https://github.com/pgjdbc/pgjdbc/pull/1215)
- Include section on how to submit a bug report in CONTRIBUTING.md [PR 951](https://github.com/pgjdbc/pgjdbc/pull/951)

### Fixed
- getString for PGObject-based types returned "null" string instead of null [PR 1154](https://github.com/pgjdbc/pgjdbc/pull/1154)
- Field metadata cache can be disabled via databaseMetadataCacheFields=0 [PR 1052](https://github.com/pgjdbc/pgjdbc/pull/1152)
- Properly encode special symbols in passwords in BaseDataSource [PR 1201](https://github.com/pgjdbc/pgjdbc/pull/1201)
- Adjust date, hour, minute, second when rounding nanosecond part of a timestamp [PR 1212](https://github.com/pgjdbc/pgjdbc/pull/1212)
- perf: reduce memory allocations in query cache [PR 1227](https://github.com/pgjdbc/pgjdbc/pull/1227)
- perf: reduce memory allocations in SQL parser [PR 1230](https://github.com/pgjdbc/pgjdbc/pull/1230), [PR 1233](https://github.com/pgjdbc/pgjdbc/pull/1233)
- Encode URL parameters in BaseDataSource [PR 1201](https://github.com/pgjdbc/pgjdbc/pull/1201)
- Improve JavaDoc formatting [PR 1236](https://github.com/pgjdbc/pgjdbc/pull/1236)


<!--more-->

**Commits by author**

AlBundy33 (1):

* fix: support parenthesis in {oj ...} JDBC escape syntax [PR 865](https://github.com/pgjdbc/pgjdbc/pull/865) [38356e68](https://github.com/pgjdbc/pgjdbc/commit/38356e6889613a65fc48a455495f18dbb3565731)

AlexElin (3):

* refactor: deprecate Fastpath API [PR 903](https://github.com/pgjdbc/pgjdbc/pull/903) [f8e21b63](https://github.com/pgjdbc/pgjdbc/commit/f8e21b63071f39f7f7754bfbfd051828884c1fd5)
* refactor: migrate MultiHostsConnectionTest to JUnit4 [PR 886](https://github.com/pgjdbc/pgjdbc/pull/886) [17a4d6a5](https://github.com/pgjdbc/pgjdbc/commit/17a4d6a500d4456c8bcac63d3d0cbb282fc99bea)
* refactor: simplify PgConnection.java [PR 1047](https://github.com/pgjdbc/pgjdbc/pull/1047) [ba360f73](https://github.com/pgjdbc/pgjdbc/commit/ba360f731cb9a2eca9924b700cee234aba572fe5)

Dave Cramer (3):

* fixed spelling mistake in PostgreSQL [PR 1202](https://github.com/pgjdbc/pgjdbc/pull/1202) [b92bd65a](https://github.com/pgjdbc/pgjdbc/commit/b92bd65a0860cc9f34b667a9fa34d7acca6aac5d)
* docs: improve javadocs in PgResultSetMetaData [PR 792](https://github.com/pgjdbc/pgjdbc/pull/792) [825c0924](https://github.com/pgjdbc/pgjdbc/commit/825c092483aa8a4ea1d0937cd081f1657983aa6d)
* minor language updates [PR 1241](https://github.com/pgjdbc/pgjdbc/pull/1241) [e19ee7ae](https://github.com/pgjdbc/pgjdbc/commit/e19ee7ae5742ec0cd8976c66ae22e7e500e0107b)

Hari Babu Kommi (2):

* spelling mistake correction [PR 1181](https://github.com/pgjdbc/pgjdbc/pull/1181) [e88abd79](https://github.com/pgjdbc/pgjdbc/commit/e88abd79bae4eab71561539784ccdb6b04d52cee)
* fix: set the loggerName in ConnectionFactoryImpl.log [PR 1188](https://github.com/pgjdbc/pgjdbc/pull/1188) [f78a639d](https://github.com/pgjdbc/pgjdbc/commit/f78a639d1ed3c64e80e1fa107691b4af5945cb84)

Jesper Pedersen (1):

* perf: guard logging statements [PR 1112](https://github.com/pgjdbc/pgjdbc/pull/1112) [7a0b7d65](https://github.com/pgjdbc/pgjdbc/commit/7a0b7d65582a21376fc114eb197b5bae1fe1ea00)

Jorge Solorzano (6):

* fix: error on Travis build head [PR 1186](https://github.com/pgjdbc/pgjdbc/pull/1186) [354d2857](https://github.com/pgjdbc/pgjdbc/commit/354d2857664559636a4d3b18568cb69adc47f349)
* test: add coverage for extendedCacheEverything [PR 1062](https://github.com/pgjdbc/pgjdbc/pull/1062) [f4d503c2](https://github.com/pgjdbc/pgjdbc/commit/f4d503c2ef449e8c2db0c23c27aedb09af30df62)
* Update after\_n\_builds to 10 [PR 1193](https://github.com/pgjdbc/pgjdbc/pull/1193) [2f9fed45](https://github.com/pgjdbc/pgjdbc/commit/2f9fed45104b56d7e2b2802359a04321755266a6)
* test: drop OpenJ9 CI tests [PR 1196](https://github.com/pgjdbc/pgjdbc/pull/1196) [9b6506df](https://github.com/pgjdbc/pgjdbc/commit/9b6506dfa1076ad27a16de8fc3e85bc23f1a5b97)
* fix: logger should be generally quiet [PR 1187](https://github.com/pgjdbc/pgjdbc/pull/1187) [30f06e14](https://github.com/pgjdbc/pgjdbc/commit/30f06e1411373d72ab59debc352ddf746f6812da)
* docs: improve CONTRIBUTING.md [PR 951](https://github.com/pgjdbc/pgjdbc/pull/951) [38c8845e](https://github.com/pgjdbc/pgjdbc/commit/38c8845e645cabce89e7610d1d5e735cc30543b1)

KimBisgaardDmi (1):

* fix: getString for PGObject columns returns null [PR 1154](https://github.com/pgjdbc/pgjdbc/pull/1154) [bbb6c1f8](https://github.com/pgjdbc/pgjdbc/commit/bbb6c1f8ac395fa793e09216ba3b710b0f6a2077)

Marc Slemko (1):

* fix: allow disabling field metadata cache [PR 1052](https://github.com/pgjdbc/pgjdbc/pull/1052) [6ce91721](https://github.com/pgjdbc/pgjdbc/commit/6ce91721048dea0e73231fa50c365108e9b9d49d)

Michele Mancioppi (1):

* docs: clarify database and username for the build [PR 859](https://github.com/pgjdbc/pgjdbc/pull/859) [83f2e385](https://github.com/pgjdbc/pgjdbc/commit/83f2e385947c56376a03fc14178f5d28e427c832)

Pavel Raiskup (1):

* packaging: fix RPM build requirements [6bb72e69](https://github.com/pgjdbc/pgjdbc/commit/6bb72e69ee274e55a5ec08aec3316aa78aa3fab4)

Sidi Mohamed EL AATIFI (1):

* Fix typos in java8-date-time.md [PR 1174](https://github.com/pgjdbc/pgjdbc/pull/1174) [dde8c020](https://github.com/pgjdbc/pgjdbc/commit/dde8c0200c409a525ef3bfc7a0aa81e7cd458a59)

Stephen Nelson (2):

* chore: add missing javadoc tags to avoid warnings [PR 1164](https://github.com/pgjdbc/pgjdbc/pull/1164) [e9ced455](https://github.com/pgjdbc/pgjdbc/commit/e9ced455fd118731eb7dea38a63e0b400df32a1b)
* docs: correct the Javadoc and enforce with Checkstyle [PR 1236](https://github.com/pgjdbc/pgjdbc/pull/1236) [08631ccd](https://github.com/pgjdbc/pgjdbc/commit/08631ccdabdb8ba6d52f398e2b0b46a9cf0cafbf)

Vladimir Sitnikov (19):

* reflect 42.2.2 release in readme.md [b1581e99](https://github.com/pgjdbc/pgjdbc/commit/b1581e99b6da96b6e44753ce231ec3acf9869fea)
* fix: avoid NPE in PgConnection.finalize [PR 1206](https://github.com/pgjdbc/pgjdbc/pull/1206) [03a1441b](https://github.com/pgjdbc/pgjdbc/commit/03a1441bbe98525412df754d3934141bc3b12168)
* chore: update gettext plugin, sort po files [eb5c8fdd](https://github.com/pgjdbc/pgjdbc/commit/eb5c8fdd6b37eb29262713584d01d73b8b7d299a)
* chore: sort messages in *.po files [10fc2fbb](https://github.com/pgjdbc/pgjdbc/commit/10fc2fbb35537e4f75c22dc7614f76b376e3f0d8)
* chore: remove obsolete translations [ed1eab9e](https://github.com/pgjdbc/pgjdbc/commit/ed1eab9ef70e499310f6730ce7ef0d5bf7bfb3ae)
* doc: add Russian translation to "No IOException expected..." [eaa0acad](https://github.com/pgjdbc/pgjdbc/commit/eaa0acad343027bf8be48b3229ef9f6386d67810)
* fix: adjust date, hour, minute, second when rounding timestamp [PR 1212](https://github.com/pgjdbc/pgjdbc/pull/1212) [4dc98be8](https://github.com/pgjdbc/pgjdbc/commit/4dc98be81829bbff3bb00c23214606757df16fab)
* chore: remove ubenchmark module due to licensing issues [PR 1215](https://github.com/pgjdbc/pgjdbc/pull/1215) [88ec13bb](https://github.com/pgjdbc/pgjdbc/commit/88ec13bb67d5bb2dbd2fc57046e05f9a3eb66abb)
* chore: remove ubenchmark from packaging/rpm as well [a699965a](https://github.com/pgjdbc/pgjdbc/commit/a699965ae209c32ce234fb455f04ffe6b1d1e0e5)
* fix: support query timeouts exceeding 2147483 seconds (~25 days) [PR 1224](https://github.com/pgjdbc/pgjdbc/pull/1224) [b7fd9f3c](https://github.com/pgjdbc/pgjdbc/commit/b7fd9f3cef734b4c219e2f6bc6c19acf68b2990b)
* perf: improve performance of replacing JDBC {...} escapes [PR 1230](https://github.com/pgjdbc/pgjdbc/pull/1230) [177f63be](https://github.com/pgjdbc/pgjdbc/commit/177f63be788a80529bfa7c2234cfabb039cc29b4)
* docs: use union merge strategy for CHANGELOG [PR 1107](https://github.com/pgjdbc/pgjdbc/pull/1107) [70189203](https://github.com/pgjdbc/pgjdbc/commit/70189203574d9f0faf37b8a9bcee1d76ffa6b676)
* chore: use 5432 as default port when running code from IDE [5dc03f63](https://github.com/pgjdbc/pgjdbc/commit/5dc03f63f170ed371a4f4ba06d491be489627b11)
* docs: use "PR 42" references instead of "PR[PR 42](https://github.com/pgjdbc/pgjdbc/pull/42)" in the changelog (#1239) [f4ae60ec](https://github.com/pgjdbc/pgjdbc/commit/f4ae60eca7b6dd8828f9e1b7a53c1dfee38f8201)
* test: close of replication connection has not been fixed at backend side, so disable the test till 12.1 [PR 1243](https://github.com/pgjdbc/pgjdbc/pull/1243) [481460a3](https://github.com/pgjdbc/pgjdbc/commit/481460a32426c3d3a532f2a9a1b078ed9e98129a)
* perf: avoid string allocation for oid/rows parsing in command tag [PR 1232](https://github.com/pgjdbc/pgjdbc/pull/1232) [da831de5](https://github.com/pgjdbc/pgjdbc/commit/da831de521953aa1c168928173c9e75336682e29)
* docs: prepare changelog for 42.2.3 release [c5f5d8d2](https://github.com/pgjdbc/pgjdbc/commit/c5f5d8d28f34ad9acaa58b241ad4a265547c990b)
* chore: fetch contributors' URL via GitHub API [d7297984](https://github.com/pgjdbc/pgjdbc/commit/d7297984a27c5a033571fbfcece62a1c849e2ec0)
* docs: update site for 42.2.3

bazzargh (1):

* fix: encode url query parameters DataSource [PR 1201](https://github.com/pgjdbc/pgjdbc/pull/1201) [9f3838f7](https://github.com/pgjdbc/pgjdbc/commit/9f3838f749d370a13a2fcef8e3ef67062d6e35eb)

benbenw (2):

* refactor: remove obsolete outParmBeforeFunc [PR 1234](https://github.com/pgjdbc/pgjdbc/pull/1234) [71028532](https://github.com/pgjdbc/pgjdbc/commit/71028532bcbc36e8239a4a7f9ad87e1acd070dc9)
* perf: improve parsing performance of JDBC-style { call ...} calls [PR 1233](https://github.com/pgjdbc/pgjdbc/pull/1233) [435e2f79](https://github.com/pgjdbc/pgjdbc/commit/435e2f791bc848494b4f08c5d0b90ecf520ae5fe)

benoit (3):

* perf: reduce memory allocations when JDBC escapes ({fn ...}) are used [2a1e0910](https://github.com/pgjdbc/pgjdbc/commit/2a1e09100c4d56a37c84668135ec7fe3e05962cb)
* refactor: use singleArgumentFunctionCall in EscapedFunctions [191d84eb](https://github.com/pgjdbc/pgjdbc/commit/191d84eb7541a0eba0a0f0eaac0f45e6e0c80ce4)
* perf: avoid BaseQueryKey.toString in CachedQuery.getSize [PR 1227](https://github.com/pgjdbc/pgjdbc/pull/1227) [669fc31e](https://github.com/pgjdbc/pgjdbc/commit/669fc31ec187b27d15ee24f84c389260c54ddf25)

bpd0018 (1):

* style: rephrase comment on named portals [PR 1129](https://github.com/pgjdbc/pgjdbc/pull/1129) [86c46f94](https://github.com/pgjdbc/pgjdbc/commit/86c46f94535823ab7f6edde25f38d6e1182272a0)

Étienne BERSAC (1):

* docs: fix link to GitHub documentation [PR 1191](https://github.com/pgjdbc/pgjdbc/pull/1191) [655b6e70](https://github.com/pgjdbc/pgjdbc/commit/655b6e70b471da29b49124399eb0dab607dfc221)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[AlBundy33](https://github.com/AlBundy33)  
[AlexElin](https://github.com/AlexElin)  
[bazzargh](https://github.com/bazzargh)  
[benbenw](https://github.com/benbenw)  
[benoit](https://github.com/benbenw)  
[bpd0018](https://github.com/bpd0018)  
[Dave Cramer](davec@postgresintl.com)  
[Étienne BERSAC](https://github.com/bersace)  
[Hari Babu Kommi](https://github.com/kommiharibabu)  
[Jesper Pedersen](https://github.com/jesperpedersen)  
[Jorge Solorzano](https://github.com/jorsol)  
[KimBisgaardDmi](https://github.com/KimBisgaardDmi)  
[Marc Slemko](https://github.com/znep)  
[Michele Mancioppi](https://github.com/michele-mancioppi)  
[Pavel Raiskup](https://github.com/praiskup)  
[Sidi Mohamed EL AATIFI](https://github.com/elaatifi)  
[Stephen Nelson](https://github.com/lordnelson)  
[Vladimir Sitnikov](https://github.com/vlsi)  
