#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void error1(char *s)
{
	write(2, s, strlen(s));
}

void error2(char *s1, char *s2)
{
	error1(s1); error1(s2);
}

char buf[4096];

int main(int argc, char* argv[])
{
	int fd, i;
	ssize_t size;
	char *s = buf + 5;
	char *end = buf + sizeof(buf);
	char *newargv[1003];
	char *path;
	int newargc = 0;
	int noarg = 0;

	if (argc < 2) {
		error1("utf8script: too few arguments\n");
		exit(1);
	}
	fd = open(argv[1], O_RDONLY);
	if (fd == -1) {
		perror(argv[1]);
		exit(1);
	}
	size = read(fd, buf, sizeof(buf));
	if (size == -1) {
		perror(argv[1]);
		exit(1);
	}
	if (strncmp(buf, "\xef\xbb\xbf#!", 5) != 0) {
		error2(argv[1], ": not a UTF-8 script\n");
		exit(1);
	}
	if (argc > 1021) {
		error1("utf8script: implementation limit: more than 1000 arguments\n");
		exit(1);
	}
	/* new executable */
	while (*s == ' ' && s != end) s++;
	if (s == end) {
		error2(argv[1], ": too many spaces\n");
		exit(1);
	}
	newargv[newargc++] = path = s;
	while (*s != ' ' && *s != '\n' && s < end)
		s++;
	if (s == end) {
		error2(argv[1], ": script path too long\n");
		exit(1);
	}
	if (*s == '\n')
		noarg = 1;
	*s++ = '\0';
	/* optionally one argument */
	if (!noarg) {
		while (*s == ' ' && s < end) s++;
		if (s == end) {
			error2(argv[1], ": first line too long\n");
			exit(1);
		}
		if (*s != '\n' && s != end) {
			newargv[newargc++] = s;
			while (*s != ' ' && *s != '\n' && s < end)
				s++;
			if (s == end) {
				error2(argv[1], ": first line too long\n");
				exit(1);
			}
			*s = '\0';
		}
	}
	for (i = 1; i < argc; i++)
		newargv[newargc++] = argv[i];
	newargv[newargc++] = 0;
	execv(path, newargv);
	perror(path);
	exit(1);
}
