"""
numarray.ma is a port of Paul Dubois' MA packge for Numeric.

numarray.linear_algebra, numarray.fft, and numarray.random_array are
likewise ports of Numeric's LinearAlgebra, FFT, and RandomArray.

numarray.convolve and numarray.image were created for numarray.
"""

import os, sys
from distutils.core import Extension

if os.environ.has_key('USE_LAPACK'):
    BUILTIN_BLAS_LAPACK = 0
else:
    BUILTIN_BLAS_LAPACK = 1

if BUILTIN_BLAS_LAPACK:
    sourcelist = [
        os.path.join('Packages/LinearAlgebra2/Src', 'lapack_litemodule.c'),
        os.path.join('Packages/LinearAlgebra2/Src', 'blas_lite.c'),
        os.path.join('Packages/LinearAlgebra2/Src', 'f2c_lite.c'),
        os.path.join('Packages/LinearAlgebra2/Src', 'zlapack_lite.c'),
        os.path.join('Packages/LinearAlgebra2/Src', 'dlapack_lite.c')
        ]
    lapack_libs = []
else:
    sourcelist = [
        os.path.join('Packages/LinearAlgebra2/Src', 'lapack_litemodule.c'),
        ]

    # Set to list off libraries to link against.
    # (only the basenames, e.g. 'lapack')
    lapack_libs = ['lapack', 'f77blas', 'cblas', 'atlas', 'f90math', 'fio', 'f77math', 'm']


# Set to list directories to be searched for BLAS and LAPACK libraries
lapack_dirs = ['/usr/local/lib/atlas', '/opt/absoft/lib']

ADDONS_DATA_FILES = [('numarray/ma', ['Packages/MA/Legal.htm'])]

ADDONS_PACKAGES = ["numarray.convolve",
                   "numarray.fft",
                   "numarray.linear_algebra",
                   "numarray.random_array",
                   "numarray.image",
                   "numarray.nd_image",
                   "numarray.ma",
                   "numarray.mlab",
                   ]

ADDONS_PACKAGE_DIRS = {"numarray.convolve":"Packages/Convolve/Lib",
                       "numarray.fft": "Packages/FFT2/Lib",
                       "numarray.linear_algebra":"Packages/LinearAlgebra2/Lib",
                       "numarray.random_array":"Packages/RandomArray2/Lib",
                       "numarray.image":"Packages/image/Lib",
                       "numarray.nd_image":"Packages/nd_image/Lib",
                       "numarray.ma":"Packages/MA/Lib",
                       "numarray.mlab":"Packages/mlab/Lib",
                       }

ADDONS_EXTENSIONS = [
    Extension("numarray.convolve._correlate",
              ["Packages/Convolve/Src/_correlatemodule.c"],
              include_dirs = ['Include/numarray']),
    Extension("numarray.image._combine",
              ["Packages/image/Src/_combinemodule.c"],
              include_dirs = ['Include/numarray']),
    Extension("numarray.nd_image._nd_image",
              ["Packages/nd_image/Src/nd_image.c",
               "Packages/nd_image/Src/ni_filters.c",
               "Packages/nd_image/Src/ni_fourier.c",
               "Packages/nd_image/Src/ni_interpolation.c",
               "Packages/nd_image/Src/ni_measure.c",
               "Packages/nd_image/Src/ni_morphology.c",
               "Packages/nd_image/Src/ni_support.c"],
              include_dirs = ['Include/numarray','Packages/nd_image/Src']),
    Extension("numarray.convolve._lineshape",
              ["Packages/Convolve/Src/_lineshapemodule.c"],
              include_dirs = ['Include/numarray']),
    Extension('numarray.fft.fftpack',
              ['Packages/FFT2/Src/fftpackmodule.c',
               'Packages/FFT2/Src/fftpack.c'],
              include_dirs = ['Packages/FFT2/Include','Include/numarray']),
    Extension('numarray.linear_algebra.lapack_lite2',
              sourcelist,
              include_dirs = ["Packages/LinearAlgebra2/Src", 'Include/numarray'],
              library_dirs = lapack_dirs,
              libraries = lapack_libs),
    Extension("numarray.random_array.ranlib2",
              ["Packages/RandomArray2/Src/ranlib.c",
               "Packages/RandomArray2/Src/ranlibmodule.c",
               "Packages/RandomArray2/Src/com.c",
               "Packages/RandomArray2/Src/linpack.c"],
              include_dirs = ['Include/numarray']),
    ]
