/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.javax.management.remote.rmi;

import java.util.Map;
import java.util.HashMap;
import java.net.MalformedURLException;

import javax.naming.Context;
import javax.management.remote.JMXServiceURL;

import mx4j.tools.naming.CosNamingService;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.6 $
 */
public class RMIIIOPConnectorServerTest extends RMIConnectorServerTestCase
{
   private CosNamingService naming;

   public RMIIIOPConnectorServerTest(String s)
   {
      super(s);
   }

   public void startNaming() throws Exception
   {
      naming = new CosNamingService(getNamingPort());
      naming.start();
      Thread.sleep(5000);
   }

   public void stopNaming() throws Exception
   {
      naming.stop();
      naming = null;
      Thread.sleep(5000);
   }

   public int getNamingPort()
   {
      return 1100;
   }

   public JMXServiceURL createJMXConnectorServerAddress() throws MalformedURLException
   {
      return new JMXServiceURL("iiop", "localhost", 0);
   }

   public Map getEnvironment()
   {
      HashMap env = new HashMap();
      env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.cosnaming.CNCtxFactory");
      env.put(Context.PROVIDER_URL, "iiop://localhost:" + getNamingPort());
      return env;
   }
}
