//LabPlot : Dialog.h

#ifndef DIALOG_H
#define DIALOG_H

#include <kdialog.h>
#include <qvbox.h>
#include <kpushbutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qvalidator.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kcolorbutton.h>
#include <kcombobox.h>
#include "Worksheet.h"

class Dialog: public KDialog
{
	Q_OBJECT
public:
	Dialog(class Worksheet *p, const char *name);
protected:
	void resizeEvent(QResizeEvent *e);
	QVBox* surfaceStyle(QTabWidget *tw);
	QVBox* simpleStyle(QTabWidget *tw, Graph *graph, Style *style, Symbol *symbol);
	QVBox* annotateValuesTab(QTabWidget *tw, Graph *graph);
       	QGroupBox *vbox, *gbox;
	Worksheet *p;
	KPushButton *ok, *apply, *cancel;
	KLineEdit *filele;						// used from various dialogs
	KComboBox *cb2, *pencb, *brushcb, *sbrushcb;			// simple
	KComboBox *symbolcb, *symbolfillcb;					// simple
	KColorButton *color, *fcolor, *scolor, *sfcolor;			// simple
	QCheckBox *filled;									// simple
	KLineEdit *ssize, *widthle;							// simple
	QCheckBox *ccb, *dcb, *coloredcb, *meshcb, *relativecb;	// surface
	KLineEdit *numberle, *thresholdle;						// surface
	KComboBox *pcb, *dbrushcb;							// surface
	KColorButton *contourcolor;							// surface
	KComboBox *typecb, *positioncb;						// annotatetab
	KLineEdit *distancele;								// annotatetab
protected slots:
	void fileInfo();
private:
	void fillBrushBox(KComboBox *cb,SType t, QColor c,FType f, QColor s);
	void fillSymbolBox(QColor c, FType f, QColor s, int b);
	void fillSymbolFillBox(SType t, QColor c, QColor s, int b);
private slots:
	void styleChanged();
	void symbolChanged();
};

#endif //DIALOG_H
